/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _DRIVERMCHP_H_
#define _DRIVERMCHP_H_

using namespace std;
#include <map>
#include "iDriverLayer.h"
#include "iPlatformLayer.h"
#include "Log.h"
#include "U4ADefines.h"
#include <windows.h>
#include "_mpusbapi.h"

class DriverMCHP : public iDriverLayer {
    private:
        map<int,itemBoard> boards;
        void findU4ABoards();
        void dscToMCHP(int, char *);
        int getInstance(int);
        iPlatformLayer * pl;
        log *l;
    public:
        DriverMCHP();
        ~DriverMCHP();
        int* getU4ABoards(int&);
        int qtyDsc(int);
        dscEndpoint* getEndpointDsc(int, int);
        int openIn(int, int, int);
        int openOut(int, int, int);
        bool close(int);
        bool sendInt(int, char *, int, int);
        bool sendCtrl(int, char*, int, int);
        bool sendIso(int, char*, int, int);
        bool sendBulk(int, char*, int, int);
        char* receiveInt(int, int&, bool&, int);
        char* receiveCtrl(int, int&, bool&, int);
        char* receiveIso(int, int&, bool&, int);
        char* receiveBulk(int, int&, bool&, int);
};

#endif
